// Split stages into header (first 0x10 bytes), data (next 0x4A4 bytes), and JPEG (remainder)

#include <stdio.h>
#include <stdlib.h>
#include <sys\stat.h>

int main(int argc, char *argv[]) {
    FILE *fp_i, *fp_o1, *fp_o2, *fp_o3;
    unsigned int i = 0;

    if(argc != 5) {
        printf("Usage: SplitStage input_file output_header output_data output_jpeg\n");
        exit(-1);
    }
    fp_i = fopen(argv[1], "rb");
    if(fp_i == NULL) {
        printf("Error opening input file %s.\n", argv[1]);
        exit(-1);
    }
    fp_o1 = fopen(argv[2], "wb");
    if(fp_o1 == NULL) {
        printf("Error opening output file %s.\n", argv[2]);
        fclose(fp_i);
        exit(-1);
    }
    fp_o2 = fopen(argv[3], "wb");
    if(fp_o2 == NULL) {
        printf("Error opening output file %s.\n", argv[3]);
        fclose(fp_i);
        fclose(fp_o1);
        exit(-1);
    }
    fp_o3 = fopen(argv[4], "wb");
    if(fp_o3 == NULL) {
        printf("Error opening output file %s.\n", argv[4]);
        fclose(fp_i);
        fclose(fp_o1);
        fclose(fp_o2);
        exit(-1);
    }

    for (i = 0; i < 0x10; i++) {
        fputc(fgetc(fp_i), fp_o1);
    }
    for (i = 0; i < 0x4A4; i++) {
        fputc(fgetc(fp_i), fp_o2);
    }
    while(!feof(fp_i)) {
        fputc(fgetc(fp_i), fp_o3);
    }

    fclose(fp_i);
    fclose(fp_o1);
    fclose(fp_o2);
    fclose(fp_o3);
    //chmod(argv[2], 0777); // for some reason umask didn't seem to work for this
    return 0;
}
